import algds.IOUtils;
/**
 * AlgDs WS99 Aufgabe 36.
 * Multiplikation von zwei Dualzahlen.
 *
 * n := maximum(Stellenzahl von x, Stellenzahl von y)
 * Laufzeit: O(n*n)
 * [ Laufzeit prop. (Stellenzahl von x) * (Anzahl der Einsen in y) ]
 * 
 * @author Christian Semrau
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
public class ChS_Aufg36 {
/** Rueckumwandlung boolean[] in String. */
public static String arraytostring(boolean[] f) {
	char[] c = new char[f.length]; int i = f.length - 1, j = 0;
	while (i >= 1 && !f[i])	i--; // fuehrende Nullen uebergehen
	while (i >= 0) c[j++] = (f[i--] ? '1' : '0');
	return new String(c, 0, j);
}
/** Eingabe von zwei Dualzahlen und Ausgabe des Produkts. */
public static void main(String args[]) {
	System.out.println("AlgDs WS99 Aufgabe 36, Christian Semrau 14.01.2000");

	System.out.print("Eingabe von x (binaer): ");
	String strX = IOUtils.readString();
	System.out.print("Eingabe von y (binaer): ");
	String strY = IOUtils.readString();

	boolean[] x = stringtoarray(strX);
	boolean[] y = stringtoarray(strY);
	System.out.println("x = "+arraytostring(x)+"\n"+"y = "+arraytostring(y));

	boolean[] z = mult(x, y);
	System.out.println("x * y = "+arraytostring(z));
}
/** Liefert das Produkt zweier boolean[]-Dualzahlen als boolean[]. */
public static boolean[] mult(boolean[] x, boolean[] y) {
	boolean[] z = new boolean[x.length + y.length];
	boolean s, u = false;
	for (int i = 0; i < y.length; i++)  // die Stellen von y durchgehen
	if (y[i]) {  // bei jeder 1: x verschoben zu z addieren
		for (int k = 0; k < x.length; k++) {
			// Falls wir Arithmik natuerlicher Zahlen zulassen, ist
			// dieser Block besser.
			/*
			byte s1 = (byte)((x[k]?1:0)+(z[k + i]?1:0)+(u?1:0));
			s = s1%2==1; u = s1>1;
			*/
			// Falls wir nur logische Operationen zulassen, ist
			// dieser Block noetig.
			s = (u == (x[k] == z[k + i]));
			u = (x[k] && z[k + i]) || (u && (x[k] || z[k + i]));

			z[k + i] = s;
		}
		if (u) { z[x.length + i] = u; u = false; }
	}
	return z;
}
/** Umwandlung String in boolean[]. */
public static boolean[] stringtoarray(String s) {
	boolean[] f = new boolean[s.length()]; int i = 0, j = f.length - 1;
	while(j >= 0) f[i++] = (s.charAt(j--) != '0');
	return f;
}
}