import java.awt.*;
import java.awt.event.*;
/**
 * AlgDs WS99 Aufgabe 35.
 * Turtle-Grafik und Koch-Kurve.
 *
 * Loses Mischwerk aus Fragmenten von: (in order of appearance)
 * Guido Krueger (Go To Java 2, Verstaendnis der Grafikprimitive),
 * Maik Broemme (seine Loesung, Grundlage fuer's Grosseganze),
 * Kai Uwe Sattler (Pythagoras, Grundlage fuer Konstruktor).
 * 
 * @author Christian Semrau
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
class ChS_Aufg35 extends java.awt.Frame {
	double angle; // aktueller Winkel in Grad
	// 0 Grad entspricht 3-Uhr-Richtung, pos. Winkel = Uhrzeigersinn
	double xpos, ypos; // aktuelle Position
	// relativ zum Fenster, nicht zum Darstellungsbereich!
	boolean isPenDown; // "ist Stift unten"
	// true: Linie zeichnen, false: bewegen ohne zeichnen
	// bringt die Schildkroete sozusagen zum "fliegen"

	int iterations; // max. Iterationen fuer Kochkurve

/** ChS_Aufg35 constructor. Initialisiert das Fenster. */
public ChS_Aufg35(String title) {
	super(title);
	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent event) { System.exit(0); }
	}); // Diese Anweisung ist noetig,
	// damit das Fenster durch einen Klick auf das Kreuz rechts oben
	// oder den Standard-Befehl Schliessen geschlossen werden kann
	setBackground(Color.white);
	setSize(600,400); // Gesamt-Fenstergroesse

	iterations = 1; // Startwert: 1 Iteration

	// Ein grosser Teil des folgenden Codes ist aus Pythagoras.java uebernommen
	// und angepasst.

	/* Aufbau eines Mens zum Neuzeichnen ("Redraw") und
	   Beenden ("Quit") der Applikation */
	MenuBar menubar = new MenuBar ();
	setMenuBar (menubar);
	Menu file = new Menu ("File");
	menubar.add (file);
	Menu angle = new Menu ("Iterations");
	menubar.add (angle);
	MenuItem redraw, quit;
	file.add (redraw = new MenuItem ("Redraw",
		new MenuShortcut (KeyEvent.VK_R)));
	file.addSeparator ();
	file.add (quit = new MenuItem ("Quit",
		new MenuShortcut (KeyEvent.VK_Q)));
	redraw.addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { repaint(); }
	});
	quit.addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { System.exit (0); }
	});

	/* Aufbau eines Mens zum Setzen der Iterationen */
	MenuItem[] angles = new MenuItem[6];
	angle.add (angles[1] = new MenuItem ("1", new MenuShortcut(KeyEvent.VK_1)));
	angle.add (angles[2] = new MenuItem ("2", new MenuShortcut(KeyEvent.VK_2)));
	angle.add (angles[3] = new MenuItem ("3", new MenuShortcut(KeyEvent.VK_3)));
	angle.add (angles[4] = new MenuItem ("4", new MenuShortcut(KeyEvent.VK_4)));
	angle.add (angles[5] = new MenuItem ("5", new MenuShortcut(KeyEvent.VK_5)));
	angle.add (angles[0] = new MenuItem ("Max", new MenuShortcut(KeyEvent.VK_6)));

	angles[0].addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { setIter(1000);
		//1000 wird nicht erreicht, es wird bei laenge<0.5 abgebrochen
		}
	});
	angles[1].addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { setIter(1); }
	});
	angles[2].addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { setIter(2); }
	});
	angles[3].addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { setIter(3); }
	});
	angles[4].addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { setIter(4); }
	});
	angles[5].addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent e) { setIter(5); }
	});

	/* Zentrieren des Windows in der Mitte des Bildschirms */
	Dimension scrSize = Toolkit.getDefaultToolkit ().getScreenSize ();
	Dimension frSize = getSize ();
	if (frSize.height > scrSize.height) 
	  frSize.height = scrSize.height;
	if (frSize.width > scrSize.width) 
	  frSize.width = scrSize.width;
	setLocation ((scrSize.width - frSize.width) / 2,
		 (scrSize.height - frSize.height) / 2);

	setVisible(true);
}

/** 1 Schritt rueckwaerts = -1 Schritt vorwaerts, ist doch klar, oder? */
public void backward(double dist, Graphics g) { forward(-dist, g); }

/** Zeichnet eine Linie in die gesetzte Richtung. */
public void forward(double dist, Graphics g) {
	// Wer das nicht versteht, zeichne sich ein rechtwinkliges Dreieck mit
	// rechtem Winkel rechts unten, stelle die Formeln fuer sin und cos am
	// Dreieck auf, und mache sich klar, dass dist die Hypothenuse,
	// x die waagerechte Kathete und y die senkrechte ist.
	double newx = xpos + dist*Math.cos(angle*Math.PI/180);
	double newy = ypos + dist*Math.sin(angle*Math.PI/180);
	if (isPenDown)
		g.drawLine(
		(int)Math.round(xpos), (int)Math.round(ypos),
		(int)Math.round(newx), (int)Math.round(newy));
	xpos = newx;
	ypos = newy;
}

/**
 * Zeichnet die Kochkurve.
 * @param iter Verbleibende Iterationstiefe
 * @param len Laenge der Basislinie
 * @param g java.awt.Graphics
 */
public void kochkurve(int iter, double len, Graphics g) {
	if (iter<=0||len<0.5){
		forward(len,g);
	}else{
		//forward(len,g); backward(len,g);
		kochkurve(iter-1,len/3,g);
		turn(-60);
		kochkurve(iter-1,len/3,g);
		turn(2*60);
		kochkurve(iter-1,len/3,g);
		turn(-60);
		kochkurve(iter-1,len/3,g);
	}
}

/** Eine so kurze main wuensch ich mir oefter. */
public static void main(java.lang.String[] args) {
	ChS_Aufg35 F = new ChS_Aufg35("Turtle-Grafik by Christian Semrau");
}

/** Das ist das Haus ... */
public void nikolaus(double basis, Graphics g) {
	double basisdiag = basis*Math.sqrt(2);
	forward(basis,g); turn(-90); forward(basis,g); turn(-90);
	forward(basis,g); turn(-90); forward(basis,g); turn(-135);
	forward(basisdiag  ,g); turn(-90); forward(basisdiag/2,g); turn(-90);
	forward(basisdiag/2,g); turn(-90); forward(basisdiag  ,g); turn(-45);

	turn(-90);
	forward(basis,g); turn(-45); forward(basisdiag/6,g); turn(45);
	forward(basis/3,g); turn(-90); forward(basis/6,g); turn(-90);
	forward(basis/6,g);
}

/**
 * Stellt die Zeichenflaeche dar.
 * @param g java.awt.Graphics - der aktuelle Grafikkontext
 */
public void paint(Graphics g) {
	Rectangle bounds = g.getClipBounds(); // Zeichenbereich holen
	g.setColor(Color.white);
	g.fillRect(bounds.x, bounds.y, bounds.width-1, bounds.height-1); // weiss malen
	g.setColor(Color.black);
	angle = 0;
	xpos = bounds.x+10; // Startposition festlegen
	ypos = bounds.y+bounds.height-10;
	isPenDown = true;
	kochkurve(iterations, bounds.width-20, g); // auf geht's
//	nikolaus(bounds.height/2, g);
}

/** Setzt die maximale Iterationstiefe und zeichnet das Fenster neu. */
public void setIter(int i) { iterations = i; repaint(); }

/** true: "Stift aufsetzen", false: "Stift anheben" */
public void setPen(boolean down) { isPenDown = down; }

/** Aendert die Drehrichtung, positive Winkel gehen im Gegenuhrzeigersinn. */
public void turn(double degree) { angle += degree; }
}