import mathe.FormattedOut;
//import ChS_Aufg31;
/**
 * AlgDs, WS99, Aufgabe 32
 * int[] sortieren mit mehreren InsertionSort-Versionen.
 *
 * Ergebnisse:
 *           aufsteigend       absteigend        zufaellig        
 * linear : V:   999,K:   999 V:499500,K:501498 V:242469,K:243461
 * binaer : V:  8986,K:   999 V:  7995,K:501498 V:  8613,K:243461
 * V = Vergleiche, K = Kopierungen
 *
 * Die binaere Suche reduziert die Anzahl der Vergleiche beim
 * absteigenden und beim unsortieren Feld, vergleicht aber mehr
 * beim bereits sortierten Feld. An der Anzahl der Kopien aendert
 * sich nichts.
 *
 * @author Christian Semrau, 22.12.1999
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
class ChS_Aufg32 {
  // die Werte (Vergleiche und Kopien) der Sortierverfahren
  static int[] werte;
  static boolean verbose = false;


/**
 * Liefert den Index von key in feld bzw die Stelle, an der key stehen muesste.
 *
 * @return int der Index von key
 * @param feld das zu durchsuchende Feld
 * @param un untere Suchgrenze (kleinster zu untersuchender Index)
 * @param ob obere Suchgrenze (groesster zu untersuchender Index)
 * @param key das zu suchende Element
 */
public static int binaereSuche(int[]feld, int un, int ob, int key){
  int mid, a;
  do{
	mid = (un+ob)/2;                // Mitte berechnen
	a = compare(key, feld[mid]);    // vergleichen
	if (a<0)                        // auswerten
	  ob = mid-1;
	  // key < feld[mid], obere Grenze ist unter alter Mitte
	else if (a>0)
	  un = mid+1;
	  // key > feld[mid], untere Grenze ist ueber alter Mitte
	else
	  {un = ob = mid; break;}
	  // key == feld[mid], Abbruch der Suchschleife

  }while(un<=ob);

  return un;
  // wenn gefunden, dann un==ob==mid
  // wenn nicht gefunden, dann ist feld[ob] < key < feld[un], ob+1 == un,
  // und key muss an der Stelle un eingeordnet werden
}

public static int compare(int X,int Y) { werte[0]++; return X-Y;}

public static void main(String[] args) {
  System.out.println("AlgDs WS99 Aufgabe 32, Christian Semrau 22.12.1999");
  // Feld zum Speichern der Werte der einzelnen Durchlaeufe
  int[][][] wertefeld = new int[3][2][2];
  // das zu sortierende Feld
  int[] testfeld;

  //fuer alle drei Feld-Arten (sortiert, absteigend und zufaellig):
  //  ein Feld erzeugen
  //  fuer beide Versionen (linear, binaer):
  //    das zu sortierende Feld kopieren
  //    das Feld sortieren
  //    die Werte sichern
  for (int feldart=0; feldart<3; feldart++) {
	int[] originalfeld = ChS_Aufg31.initfeld(1000,feldart);
	for(int version=0; version<2; version++){
	  testfeld = (int[])originalfeld.clone();
	  sortIns(testfeld, version);
	  wertefeld[feldart][version] = werte;
	}
  }

  // Ausgabe der Ergebnisse

  String[] feldarten = new String[]{" aufsteigend", " absteigend ", " zufaellig  "};
  String[] versionen = new String[]{"linear :", "binaer :"};

  // Kopfzeile
  System.out.print("         ");
  for (int feldart=0; feldart<3; feldart++)
	System.out.print(FormattedOut.left(feldarten[feldart],6+6+6));
  System.out.println();

  // fuer beide Versionen die Werte der drei Feld-Arten ausgeben
  for(int version=0; version<2; version++){
	System.out.print(versionen[version]);
	for (int feldart=0; feldart<3; feldart++) {
	  System.out.print(
	  " V:"+FormattedOut.right(wertefeld[feldart][version][0],6)+
	  ",K:"+FormattedOut.right(wertefeld[feldart][version][1],6));
	}
	System.out.println();
  }

  // Erklaerungen
  System.out.println("V = Vergleiche, K = Kopierungen");
}

/**
 * InsertionSort
 * @param version 0 = lineare Suche, 1 = binaere Suche
 */
public static void sortIns(int [] array, int version) {
  switch (version){
	case 0: sortInsertion(array); break;
	default:sortInsertionBinaer(array);
  }
}

public static void sortInsertion(int[] feld) {
  werte = new int[2];  // werte[0] = Vergleiche, werte[1] = Kopien

  for (int i = 1; i < feld.length; i++){
	int marker = i;
	int temp = feld[i]; werte[1]++;
	while (marker > 0 && compare(feld[marker - 1],temp)>0) {
	  feld[marker] = feld[--marker]; werte[1]++;
	}
	if (marker!=i) { feld[marker] = temp; werte[1]++; }
  }
}

public static void sortInsertionBinaer(int[] feld) {
  werte = new int[2];  // werte[0] = Vergleiche, werte[1] = Kopien

  for (int i = 1; i < feld.length; i++){
	int temp = feld[i]; werte[1]++;
	int marker = binaereSuche(feld, 0, i, temp);

	if (marker!=i) {
	  // wenn kopieren noetig
	  for(int j=i; j>marker; feld[j] = feld[--j]) werte[1]++;
	  feld[marker] = temp; werte[1]++;
	}
  }
}
} // class ChS_Aufg32