import mathe.FormattedOut;
/**
 * AlgDs, WS99, Aufgabe 31.
 * int[] sortieren mit mehreren QuickSort-Versionen.
 *
 * Ergebnisse:
 *             aufsteigend     absteigend      zufaellig      
 * linkes   : V:500499,K: 999 V:500998,K:2499 V: 13735,K:8040
 * mittleres: V:  8986,K: 511 V:  8994,K:2011 V: 12320,K:7810
 * rechtes  : V:500499,K: 999 V:500998,K:2499 V: 13868,K:8088
 * V = Vergleiche, K = Kopierungen (1 Tausch = 3 Kopierungen)
 *
 * Im Durchschnitt sind alle drei Varianten gleich gut.
 * Ich habe den Eindruck, dass das mittlere als Pivot etwas (wirklich nicht viel)
 * besser ist als die beiden anderen.
 *
 * Ich habe einen Test gemacht mit 10000 Durchlaeufen, bei denen ein
 * 1000er Feld von Zufallspermutationen mit allen drei Varianten sortiert
 * wurde. Dabei habe ich die Gesamtzahl von Vergleichen und Kopien pro Variante
 * gezaehlt, sowie welche Variante jeweils einen Durchlauf mit den wenigsten
 * Vergleichen bzw. Kopien beendet hat.
 *
 * Pivot:    Linkes   Mittleres  Rechtes    (Anteile)
 * ---------------------------------------------------
 * Vergl: {146463378,131379294,146002577} = {34%,30%,34%}
 * Kopien: {80000775, 78186483, 80027175} = {33%,32%,33%}
 *  (Summe der Vergleiche bzw. Kopien aller 10000 Durchlaeufe, weniger ist besser)
 * wenigsteVgl: {372,     9180,      448} = { 3%,91%, 4%}
 * wenigsteKop: {727,     8608,      665} = { 7%,86%, 6%}
 *  (der jeweils beste einer Runde bekommt einen Punkt, mehr ist besser)
 * ---------------------------------------------------
 * Pivot:    Linkes   Mittleres  Rechtes  Zufaellig
 * ---------------------------------------------------
 * Vergl:  {146560856,131321670,146002736,134277101} = (26%, 24%, 26%, 24%)
 * Kopien: { 79984962, 78185799, 80032482, 79909217} = (25%, 25%, 25%, 25%)
 *  (Summe der Vergleiche bzw. Kopien aller 10000 Durchlaeufe, weniger ist besser)
 * wenigsteVgl: { 101,     6281,      132,     3486} = ( 1%, 63%,  1%, 35%)
 * wenigsteKop: { 643,     8013,      577,      767} = ( 6%, 80%,  6%,  8%)
 *  (der jeweils beste einer Runde bekommt einen Punkt, mehr ist besser)
 *
 * @author Christian Semrau, 22.12.1999
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
class ChS_Aufg31 {
  // die Werte (Vergleiche und Kopien) der Sortierverfahren
  static int[] werte;
  static boolean verbose = false;


public static int compare(int X,int Y) { werte[0]++; return X-Y;}

public static String feldOut(int[] feld) {
  if (feld==null) return "null";
  if (feld.length==0) {return "{}"; };

  String s = "{";
  for(int i=0; i<feld.length-1; i++) {
	s += FormattedOut.right(feld[i],2)+",";
	if ((i+1)%20==0) s += "\n";
  }
  return s+FormattedOut.right(feld[feld.length-1],2)+"}";
}

/**
 * Liefert ein initialisiertes Feld.
 * @param m 0 = aufsteigend (0..anzahl-1), 1 = absteigend (anzahl-1..0),
 * 2 = zufaellige Permutation der Zahlen 0..anzahl-1
 */
public static int[] initfeld(int anzahl, int m) {
  int[] feld = new int[anzahl];
  if (verbose) System.out.print(anzahl);
  switch (m){
	case 0:
	  if (verbose) System.out.println(" aufsteigend");
	  for(int i=0; i<anzahl; i++) feld[i]=i;
	  break;
	case 1:
	  if (verbose) System.out.println(" absteigend");
	  for(int i=0; i<anzahl; i++) feld[i]=anzahl-1-i;
	  break;
	case 2:
	  // erzeugt nicht mehr ein reines Zufallsfeld, sondern
	  // eine zufaellige Permutation der Zahlen 0 bis anzahl-1
	  if (verbose) System.out.println(" zufaellig");
	  for(int i=0; i<anzahl; i++) feld[i]=i;
	  for(int i=0; i<anzahl; i++) swap(feld, i, (int)(anzahl*Math.random()));
	  break;
  }
  return feld;
}

public static void main(String[] args) {
  System.out.println("AlgDs WS99 Aufgabe 31, Christian Semrau 22.12.1999");
  final int FELDARTEN = 3;
  final int VERSIONEN = 4;
  // Feld zum Speichern der Werte der einzelnen Durchlaeufe
  int[][][] wertefeld = new int[FELDARTEN][VERSIONEN][2];
  // das zu sortierende Feld
  int[] testfeld;

//fuer alle drei Feld-Arten (sortiert, absteigend und zufaellig):
//  ein Feld erzeugen
//  fuer alle drei Versionen (links, Mitte, rechts):
//    das zu sortierende Feld kopieren
//    das Feld sortieren
//    die Werte sichern
  for (int feldart=0; feldart<FELDARTEN; feldart++) {
	int[] originalfeld = initfeld(1000,feldart);
	for(int version=0; version<VERSIONEN; version++){
	  testfeld = (int[])originalfeld.clone();
	  if (verbose) System.out.println();
	  sortQuick(testfeld, version);
	  wertefeld[feldart][version] = werte;
	}
  }

  // Ausgabe der Ergebnisse

  String[] feldarten = new String[]{" aufsteigend", " absteigend ", " zufaellig  "};
  String[] versionen = new String[]{"linkes   :", "mittleres:", "rechtes  :", "zufaellig:"};

  // Kopfzeile
  System.out.print("           ");
  for (int feldart=0; feldart<FELDARTEN; feldart++)
	System.out.print(FormattedOut.left(feldarten[feldart],6+6+4));
  System.out.println();

  // fuer die drei Versionen die Werte der drei Feld-Arten ausgeben
  for(int version=0; version<VERSIONEN; version++){
	System.out.print(versionen[version]);
	for (int feldart=0; feldart<FELDARTEN; feldart++) {
	  System.out.print(
	  " V:"+FormattedOut.right(wertefeld[feldart][version][0],6)+
	  ",K:"+FormattedOut.right(wertefeld[feldart][version][1],4));
	}
	System.out.println();
  }

  // Erklaerungen
  System.out.println(
	"V = Vergleiche, K = Kopierungen (1 Tausch = 3 Kopierungen)");
}

static void sortQuick (int[] array, int version) {
  werte = new int[2];  // werte[0] = Vergleiche, werte[1] = Kopien
  sortQuick2(array, 0, array.length - 1, version);
}

/**
 * @param version 0 = linkes, 1 = mittleres, 2 = rechtes Element
 */
static void sortQuick2(int[] array, int l, int r, int version) {
  int lo = l,hi = r;
  if (hi > lo) {
	int mid;                          // Pivotelement bestimmen:
	switch (version){
	  case 0: mid = array[lo]; break; // linkes Element
	  case 2: mid = array[hi]; break; // rechtes Element
	  case 3: mid = array[(int)((hi-lo+1)*Math.random())+lo]; break; // Auswahl per zuffi
	  default:mid = array[(lo+hi)/2]; // mittleres Element
	}
	werte[1]++; // eine Kopie gemacht
	if (verbose) System.out.println("1: "+feldOut(array)+" "+mid);

	while (lo <= hi) {
	  while ((lo < r) && (compare(array[lo],mid)<0)) lo++; 
	  while ((hi > l) && (compare(array[hi],mid)>0)) hi--;
	  if (lo <= hi) {
		if (lo<hi) { // zusaetzliche Abfrage, erspart manche Kopie
	      swap(array, lo, hi); werte[1]+=3;
		};
		lo++; hi--;
	  }
	}
	if (verbose) System.out.println("2: "+feldOut(array));

	// linke Partition sortieren
	if (l < hi) sortQuick2(array, l, hi, version);
	// rechte Partition sortieren
	if (lo < r) sortQuick2(array, lo, r, version);
  }
}

static void swap (int[] array, int idx1, int idx2) {
  int tmp = array[idx1]; array[idx1] = array[idx2]; array[idx2] = tmp;
}
} // class ChS_Aufg31