/**
 * Ausfuehrung der Registermaschinen.
 *
 * Christian.Semrau@student.uni-magdeburg.de
 * 
 * @author Christian Semrau
 */
class ChS_RegMasch {


/**
 * Maschinen von AlgDs WS99 Aufgaben 25, 26a, 26b
 * und M1 (aus der Vorlesung).
 */
public static void main(String [] args) {

	// Aufbau aller Maschinen, aber nur eine wird auch ausgefuehrt

	// eine kann aus einer Datei eingelesen werden
	/*
	String[] S = algds.IOUtils.readStringArray("RegMasch_p.txt");
	// diese Datei enthaelt das Programm, ein Befehl je Zeile
	int[] c = algds.IOUtils.readIntArray("RegMasch_c.txt");
	// diese Datei enthaelt die Register, eine Zahl je Zeile
	// ggf. muessen die Pfade mit angegeben werden
	ChS_Registermaschine2 RText = new ChS_Registermaschine2(S, c);
	*/

	// Aufgabe 25.
	ChS_Registermaschine2 R25 = new ChS_Registermaschine2(new String[] {
	"CLOAD 0",  // 1
	"STORE 2",  // 2
	"LOAD  2",  // 3
	"MULT  2",  // 4
	"STORE 3",  // 5
	"LOAD  1",  // 6
	"SUB   3",  // 7
	"IFGOTO 12",// 8
	"LOAD 2",   // 9
	"CADD 1",   //10
	"GOTO 2",   //11
	"END"       //12
	}, new int[]{0,15,0,0});
	// c[0] := 0
	// c[1] := c[1]
	// c[2] := kleinste Zahl, deren Quadrat >= c[1]
	// c[3] := kleinste Quadratzahl >= c[1]

	ChS_Registermaschine2 R25_1 = new ChS_Registermaschine2(new String[] {
	"CLOAD 0",  // 1
	"STORE 2",  // 2 , Zeile 3 (LOAD 2) wurde entfernt
	"MULT  2",  // 3
	"STORE 3",  // 4
	"LOAD  1",  // 5
	"SUB   3",  // 6
	"IFGOTO 11",// 7 , dadurch verschiebt sich das Ziel (12->11)
	"LOAD 2",   // 8
	"CADD 1",   // 9
	"GOTO 2",   //10 , dieses Ziel verschiebt sich nicht
	"END"       //11
	}, new int[]{0,15,0,0});

	// Aufgabe 26.a)
	ChS_Registermaschine2 R26a = new ChS_Registermaschine2(new String[] {
	"LOAD    2", // 1
	"IFGOTO 10", // 2
	"LOAD    1", // 3
	"CADD    1", // 4
	"STORE   1", // 5
	"LOAD    2", // 6
	"CSUB    1", // 7
	"STORE   2", // 8
	"GOTO    2", // 9
	"END"        //10
	}, new int[]{0,4,6});
	// c[0] := 0
	// c[1] := c[1] + c[2]
	// c[2] := 0

	// Aufgabe 26.b)
	ChS_Registermaschine2 R26b = new ChS_Registermaschine2(new String[] {
	"LOAD   2", // 1
	"CSUB   5", // 2
	"IFGOTO 8", // 3
	"LOAD   2", // 4
	"MULT   1", // 5
	"STORE  1", // 6
	"GOTO  11", // 7
	"LOAD   2", // 8
	"ADD    1", // 9
	"STORE  1", //10
	"END"       //11
	}, new int[]{0,7,3});
	// if c[2]<=5
	// c[0] = c[1] := c[2]+c[1]
	// c[2] := c[2]
	// if c[2]>5
	// c[0] = c[1] := c[2]*c[1]
	// c[2] := c[2]

	// M1 (Vorlesung) - Rest bei Division in Register 3
	ChS_Registermaschine2 RM1 = new ChS_Registermaschine2(new String[] {
	"LOAD  1",  // 1
	"DIV   2",  // 2
	"MULT  2",  // 3
	"STORE 3",  // 4
	"LOAD  1",  // 5
	"SUB   3",  // 6
	"STORE 3",  // 7
	"END"       // 8
	}, new int[]{0,32,5,0});
	// c[0] = c[3] := c[1] - c[1]/c[2]*c[2] = c[1] % c[2]
	// c[1] := c[1]
	// c[2] := c[2]

	// eine wird ausgefuehrt
	ChS_Registermaschine2 R = R25;

	// Programm ausgeben
	R.schreibeProgramm();
	do {
	  // vor jedem Schritt die Konfiguration ausgeben
	  R.schreibeKonfiguration();
	  // Einzelschritt
	  R.step();
	} while(!R.beendet());
	// die letzte Konfiguration ausgeben
	R.schreibeKonfiguration();
}
} // class ChS_RegMasch