import algds.IOUtils;
/**
 * Eine Handvoll Markov-Algorithmen, unter anderem auch die beiden
 * von Kai-Uwe Sattler (1, 2), VIER zu Aufgabe 27 (3, 3a, 3b, DanielBlossey),
 * zwei die zwei Dualzahlen addieren (4, 4a).
 * @author Christian Semrau, 15.12.1999
 * <a href="mailto:Christian.Semrau@Student.uni-magdeburg.de">
 * Christian.Semrau@Student.uni-magdeburg.de</a>
 */
public class ChS_MarkovUse {
	static ChS_Markov M;

// Anlegen und initialisieren der Markov-Tafel
// verdoppelt Zahl in Strichnotation
// Beispieleingabe: ||||
//--------------------------------------------------------------
public static void initialisiere1() {
//--------------------------------------------------------------
	M = new ChS_Markov(3);
	M.set(0, "|",  "x|",  1, 3);
	M.set(1, "x|", "||x", 1, 2);
	M.set(2, "x",  "",    3,-1);
}

// Anlegen und initialisieren der Markov-Tafel
// multipliziert zwei Zahlen in Strichnotation
// Beispieleingabe: |||*||||
//--------------------------------------------------------------
public static void initialisiere2 () {
//--------------------------------------------------------------
	M = new ChS_Markov(8);
	M.set(0, "*",   "**",  1, -1);
	M.set(1, "",    "*",   2, -1);
	M.set(2, "**|", "x**", 3,  6);
	M.set(3, "|x",  "x|",  4,  5);
	M.set(4, "",    "|",   3, -1);
	M.set(5, "x",   "",    2, -1);
	M.set(6, "*|",  "*",   6,  7);
	M.set(7, "***", "",    8, -1);
}

// Anlegen und initialisieren der Markov-Tafel
// Erhoeht eine Dualzahl um 1 (mit fuehrender Null), 8 Zeilen
// Beispieleingabe: 1100101 (= 101) -> 1100110 (=102)
//--------------------------------------------------------------
public static void initialisiere3 () {
//--------------------------------------------------------------
	M = new ChS_Markov(8);
	M.set(0, "",   "|0",  1, -1); // Verfahren benoetigt mind. eine 0
	M.set(1, "|1", "1|",  1,  2); // marker ans Ende..
	M.set(2, "|0", "0|",  1,  3); // verschieben
	M.set(3, "0|", "1",   5,  4); // 0 erhoehen und Marker entfernen
	M.set(4, "1|", "|0",  4,  3); // 1 auf 0 und naechste Stelle erhoehen
	M.set(5, "",   "|",   6, -1); // neuer marker am Anfang
	M.set(6, "|0", "|",   6,  7); // fuehrende Nullen entfernen
	M.set(7, "|",  "",   10, -1); // marker entfernen
}

// Anlegen und initialisieren der Markov-Tafel
// Erhoeht eine Dualzahl um 1 (mit Fallunterscheidung), 8 Zeilen
//--------------------------------------------------------------
public static void initialisiere3a () {
//--------------------------------------------------------------
	M = new ChS_Markov(8);
	M.set(0, "0",  "0",   3,  1); // ist eine 0 enthalten?
	M.set(1, "1",  "0",   1,  2); // wenn nicht, dann alles 0 machen
	M.set(2, "",   "1",   8, -1); // und 1 an den Anfang, fertig
	M.set(3, "",   "|",   4, -1); // Marker setzen und..
	M.set(4, "|1", "1|",  4,  5); // ans Ende verschieben
	M.set(5, "|0", "0|",  4,  6);
	M.set(6, "0|", "1",   8,  7); // 0 erhoehen und Marker entfernen
	M.set(7, "1|", "|0",  7,  6); // 1 auf 0 und naechste Stelle erhoehen
}

// Anlegen und initialisieren der Markov-Tafel
// Erhoeht eine Dualzahl um 1 (mit Anfangsmarker), 7 Zeilen
//--------------------------------------------------------------
public static void initialisiere3b () {
//--------------------------------------------------------------
	M = new ChS_Markov(7);
	M.set(0, "",   "x|",  1, -1); // Anfangs- und Endemarker
	M.set(1, "|1", "1|",  1,  2); // Endemarker ans Ende..
	M.set(2, "|0", "0|",  1,  3); // verschieben
	M.set(3, "0|", "1",   6,  4); // 0 erhoehen
	M.set(4, "1|", "|0",  4,  5); // 1 auf 0 und naechste Stelle betrachten
	M.set(5, "x|", "1",  10,  3); // keine Stellen mehr -> 1 setzen und fertig
	M.set(6, "x",  "",   10, -1); // Marker entfernen
}

// Anlegen und initialisieren der Markov-Tafel 
// Erhoeht eine Dualzahl um 1 (ohne Anfangsmarker), 6 (!) Zeilen 
// Sieht fast wie meiner aus, kommt aber ohne Anfangsmarker aus!
//--------------------------------------------------------------
public static void initialisiereDanielBlossey(){
//--------------------------------------------------------------
        M = new ChS_Markov(6);
	M.set(0, "",   "#",   1, -1); // Endemarker setzen
	M.set(1, "#1", "1#",  1,  2); // Endemarker ans Ende..
	M.set(2, "#0", "0#",  1,  3); // verschieben
	M.set(3, "0#", "1",  -1,  4); // 0 erhoehen und fertig
	M.set(4, "1#", "#0",  3,  5); // 1 auf 0 und naechste Stelle betrachten
	M.set(5, "#",  "1",  -1, -1); // keine Stellen mehr -> 1 setzen und fertig
}



//--------------------------------------------------------------
/* Die Algorithmen, die hier noch kommen, addieren zwei Dualzahlen
   die durch ein + getrennt sind. Sie sind nicht Teil der Aufgabe, waren
   aber eine interessante Herausforderung fuer mich.

   Ganz unten ist die main-Methode.
*/
//--------------------------------------------------------------


// Anlegen und initialisieren der Markov-Tafel
// Addiert zwei Dualzahlen, 18 Zeilen
// Beispieleingabe: 1100101+1110 (=101+14) -> 1110011 (=115)
// Endlosschleife wenn die Summe laenger ist als der erste Summand..
// und am Anfang ungueltige Zeichen stehen!
//--------------------------------------------------------------
public static void initialisiere4 () {
//--------------------------------------------------------------
	int L0 = 0;	int L1 = L0+3; int L2 = L1+4; // einige Sprunglabel
	int L3 = L2+5; int L4 = L3+3; int L5 = L4+3;

	M = new ChS_Markov(L5); // letztes Label = Anzahl der Zeilen

	M.set(L0,   "+",  "x+!",L0+1,  L5);  // x-marker und !-marker setzen
	M.set(L0+1, "!0", "0!", L0+1,L0+2);  // !-marker nach hinten..
	M.set(L0+2, "!1", "1!", L0+1,  L1);  // verschieben

	M.set(L1,   "0!", "!",  L3,L1+1);  // zu addierende ziffer ist 0
	M.set(L1+1, "1!", "!",  L2,L1+2);  // 1 zu addieren
	M.set(L1+2, "+!", "", L1+3,  -1);  // nichts mehr zu addieren
	M.set(L1+3, "x",  "",   L4,  -1);  // ab zum Aufraeumen
	
	M.set(L2,   "",   "0", L2+1,  -1);  // fuehrende 0
	M.set(L2+1, "x",  "|x",L2+2,  -1);  // |-marker ans Ende der ersten Zahl
	M.set(L2+2, "0|", "|1",L2+4,L2+3);  // 0 erhoehen
	M.set(L2+3, "1|", "|0",L2+3,L2+2);  // 1 erhoehen mit Uebertrag
	M.set(L2+4, "|",  "",    L3,  -1);  // |-marker entfernen

	M.set(L3+0, "0x", "x0",L1, L3+1);  // x-marker tauschen mit 0
	M.set(L3+1, "1x", "x1",L1, L3+2);  // x-marker tauschen mit 1
	M.set(L3+2, "x",  "x0",L1,   -1);  // x-marker steht am Anfang

	M.set(L4+0, "",   "|", L4+1,   -1);  // |-marker an den Anfang
	M.set(L4+1, "|0", "|", L4+1, L4+2);  // fuehrende Nullen entfernen
	M.set(L4+2, "|",  "",  L5,     -1);  // |-marker entfernen

	//L5
}

// Anlegen und initialisieren der Markov-Tafel
// Addiert zwei Dualzahlen, 16 Zeilen
// Beispieleingabe: 1100101+1110 (=101+14) -> 1110011 (=115)
// Endlosschleife wenn die Summe laenger ist als der erste Summand..
// und am Anfang ungueltige Zeichen stehen!
//--------------------------------------------------------------
public static void initialisiere4a () {
//--------------------------------------------------------------
	// die Sprunglabel
	int L0 =    0;  int L1 = L0+2; // L0+4 mit den beiden Zusatz-Zeilen
	int L2 = L1+2;  int L3 = L2+5;
	int L4 = L3+4;  int L5 = L4+3;

	M = new ChS_Markov(L5); // letztes Label = Anzahl der Zeilen

	M.set(L0,   "+",  "x+!",L0+1,  L5);  // x-marker und Endemarker setzen
	M.set(L0+1, "",   "y",  L0+2,  -1); // Anfangsmarker, L0+2 = L1
// diese beiden Zeilen koennen die Endlosschleife verhindern
//	M.set(L0+2, "y0", "y0", L1, L0+3);
//	M.set(L0+3, "y1", "y1", L1,   L5);

	M.set(L1,   "!0", "0!", L1+0,L1+1);  // Endemarker nach hinten..
	M.set(L1+1, "!1", "1!", L1+0,  L2);  // verschieben

	M.set(L2,   "0!", "!",  L4,L2+1);  // zu addierende ziffer ist 0
	M.set(L2+1, "1!", "!",  L3,L2+2);  // 1 zu addieren
	M.set(L2+2, "+!", "", L2+3,  -1);  // nichts mehr zu addieren
	M.set(L2+3, "x",  "", L2+4,  -1);
	M.set(L2+4, "y",  "",   L5,  -1);

	M.set(L3,   "x",  "|x", L3+1,   -1); // Marker ans Ende des zu erhoehenden Teils
	M.set(L3+1, "0|", "1",  L4,   L3+2); // 0 erhoehen
	M.set(L3+2, "1|", "|0", L3+2, L3+3); // 1 auf 0 und naechste Stelle betrachten
	M.set(L3+3, "y|", "y1", L4,   L3+1); // keine Stellen mehr -> 1 setzen und fertig

	M.set(L4,   "0x", "x0",L2, L4+1);  // x-marker tauschen mit 0
	M.set(L4+1, "1x", "x1",L2, L4+2);  // x-marker tauschen mit 1
	M.set(L4+2, "x",  "x0",L2,   -1);  // x-marker steht am Anfang

	// L5
}

//--------------------------------------------------------------
public static void main (String[] args) {
//--------------------------------------------------------------
	String wort;
	String ergebnis;

	// an dieser Stelle steht der Aufruf der gewuenschten init-Routine
	initialisiereDanielBlossey();
	
	if (M.verbose) M.drucketafel();
	System.out.print ("Eingabe-String: ");
	wort = IOUtils.readString ();
	System.out.println (" Wort:   " +wort);
	ergebnis = M.lauf(wort);
	System.out.println (" Ergebnis :   " + ergebnis);
}

} // ChS_MarkovUse.java
