import algds.IOUtils;
/**
 * Markov-Algorithmus als Klasse.
 * @author ? (vielleicht Sattler)<br>
 * Ver&auml;ndert von Christian Semrau
 */
public class ChS_Markov {
	// Ausgabe der Vergleiche bei verbose == true
	boolean verbose = true;

	// objektbezogene Markov-Tafel - sauberere Loesung, entspricht
	// bald dem Wissensstand in der Vorlesung

	int laenge;    // Anzahl Zeilen
	String[] phi;  // zu ersetzen
	String[] psi;  // ersetzt durch
	int[] i;       // Sprung bei Erfolg
	int[] j;       // Sprung bei Misserfolg

/**
 * Constructor nimmt L&auml;nge der Tafel.
 * @param l L&auml;nge der Tafel
 */
public ChS_Markov(int l) {
	laenge = l;
	phi = new String[laenge];
	psi = new String[laenge];
	i = new int[laenge];
	j = new int[laenge];
	for (int k=0; k<l; k++) {
		phi[k]=""; psi[k]=""; i[k]=-1; j[k]=-1;
	};
}
// Ausgeben der Markov-Tafel
public void drucketafel() {
for (int index=0; index<laenge; index++)
  if ((phi[index]+psi[index]).length()>0)
  System.out.println (index + "\t" + phi[index] + "\t" + 
	psi[index] +"\t" + i[index] +"\t" + j[index]);
}
/**
 * F&uuml;hrt den Algorithmus aus.
 * @param wort das Eingabewort
 * @return das Ausgabewort
 */
public String lauf ( String wort ) {
  int zeile = 0;
  int position;
  if(verbose)
	System.out.println ("  ");
  while ( zeile >= 0 && zeile < laenge ) {
	if (phi[zeile].length()==0) // leeres Suchwort extra behandeln
	  position=0; 
	else
	  // versagt, wenn wort und phi[zeile] beide leer sind!
	  position = wort.indexOf(phi[zeile]);
	if(verbose){
	  System.out.print ("Z= " + zeile + "\tW=\"" + wort 
	    + "\"\t \""+phi[zeile]+"\"->\""+psi[zeile]+"\"");
	};
	if (position >= 0) {
	// Suchwort enthalten
	  wort = 
		wort.substring(0,position)
		+ psi[zeile]
		+ wort.substring(position + phi[zeile].length());
	  zeile = i[zeile];
	} else {
	// Suchwort nicht enthalten
	  zeile = j[zeile];
	}; 
	if(verbose){
	  System.out.println (
	    "\tE=\"" + wort +"\"\t-> "+zeile); 
	}
  };
  if(verbose)
	System.out.println ("  ");
  return wort;
}
/**
 * Setzt eine Zeile des Algorithmus.
 * @param z Zeile
 * @param phi Was ersetzt werden soll
 * @param psi Durch was es zu ersetzen ist
 * @param i Sprungziel bei Erfolg
 * @param j Sprungziel bei Misserfolg
 */
public void set(int z, String phi, String psi, int i, int j) {
	this.phi[z] = phi;
	this.psi[z] = psi;
	this.i[z] = i;
	this.j[z] = j;
}
}