/**
 * AlgDs WS99 Zusatzaufgabe "Code entziffern"<p>
 *
 * die Aufgabe habe ich so gel&ouml;st in einer anderen Klasse, die
 * Code1 verwendet:<br>
 * <code>
 * String codetext =<br>
 * "emnsn haese swibf kzaen ticiu ueteb arvde enhnz ieein raetb "+<br>
 * "bwrmc seirf fmnrt hitaa gratt eeeee ridnu emnce haein denni "+<br>
 * "ursdc hlars rhitf nstga echze l";<br>
 * for(int i = 2; i &lt; codetext.length(); i++)<br>
 * System.out.println(i+" "+Code1.decode(codetext,i,0,false));<br>
 * </code>
 * (&lt; ist das kleiner-als-Zeichen, ersetzt wegen JavaDoc)
 *
 * Christian.Semrau@student.uni-magdeburg.de
 * @author Christian Semrau, 28.11.1999
 */
class Code1 {

public static String decode(String code, int breite,
int updown, boolean verbose) {
  code = filter(code);               // filtern
  int len = code.length() / breite;  // Anzahl ganzer Zeilen
  int rest= code.length() % breite;  // Laenge der letzten Zeile bzw. 0
  int maxlen = rest>0 ? len+1 : len; // Gesamtzahl der Zeilen

  // Spaltenlaengen
  int[] spaltenleng = new int[breite];
  for(int s=0; s<breite; s++)
	spaltenleng[s]=(s<rest) ? len+1 : len;
  // Zeilenlaengen
  int[] zeilenleng = new int[maxlen];
  for(int z=0; z<maxlen; z++)
	zeilenleng[z]=breite;
  if (rest>0) zeilenleng[maxlen-1]=rest;

  char[][] feld = new char[breite][]; // feld [spalten] [spaltenlaenge]

  // Spalten anlegen
  for(int s=0; s<breite; s++)
	feld[s] = new char[spaltenleng[s]];

  // die Spalten fuellen
  int pos=0;
  for(int s=0; s<breite; s++)
	if ((s%2==0)==(updown==0))
	// gerade Spalten abwaerts
	  for(int z=0; z<spaltenleng[s]; z++)
	    feld[s][z] = code.charAt(pos++);
	else
	// ungerade Spalten aufwaerts
	  for(int z=spaltenleng[s]-1; z>=0; z--)
	    feld[s][z] = code.charAt(pos++);

  if (verbose)
  for(int z=0; z<maxlen; z++) {
	for(int s=0; s<zeilenleng[z]; s++)
	  System.out.print(feld[s][z]);
	System.out.println();
  }

  // Feld zeilenweise auslesen
  String text = "";
  for(int z=0; z<maxlen; z++)
	for(int s=0; s<zeilenleng[z]; s++)
	  text += feld[s][z];

  return text;
}

public static String encode(String klartext, int breite,
int updown, boolean verbose) {
  klartext = filter(klartext);           // filtern
  int len = klartext.length() / breite;  // Anzahl ganzer Zeilen
  int rest= klartext.length() % breite;  // Laenge der letzten Zeile bzw. 0
  int maxlen = rest>0 ? len+1 : len;     // Gesamtzahl der Zeilen

  // Spaltenlaengen
  int[] spaltenleng = new int[breite];
  for(int i=0; i<breite; i++)
	spaltenleng[i]=(i<rest) ? len+1 : len;
  // Zeilenlaengen
  int[] zeilenleng = new int[maxlen];
  for(int z=0; z<maxlen; z++)
	zeilenleng[z]=breite;
  if (rest>0) zeilenleng[maxlen-1]=rest;

  char[][] feld = new char[breite][];  // feld [spalten] [spaltenlaenge]

  // Spalten anlegen
  for(int s=0; s<breite; s++)
	feld[s] = new char[spaltenleng[s]];

  // feld zeilenweise fuellen
  int pos=0;
  for(int z=0; z<maxlen; z++)
	for(int s=0; s<zeilenleng[z]; s++)
	  feld[s][z] = klartext.charAt(pos++);

  String text = "";
  // die Spalten auslesen
  for(int s=0; s<breite; s++)
	if ((s%2==0)==(updown==0))
	// gerade spalten abwaerts (oder neuerdings aufwaerts...)
	  for(int z=0; z<spaltenleng[s]; z++)
		text += feld[s][z];
	else
	// ungerade spalten aufwaerts
	  for(int z=spaltenleng[s]-1; z>=0; z--)
	    text += feld[s][z];

  if (verbose)
  for(int z=0; z<maxlen; z++) {
	for(int s=0; s<zeilenleng[z]; s++)
	  System.out.print(feld[s][z]);
	System.out.println();
  }

  String code = "";
  for (pos=0; pos<text.length(); pos++) {
	code += text.charAt(pos);
	if (pos%5==4) code += " ";
  };
  return code;
}
/*
 * Liefert einen String, der nur die Buchstaben (klein) von s enthaelt.
 * (Und neuerdings auch einige Satzzeichen.)
 */
public static String filter(String s) {
  String chars =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.:";
  String f = "";
  for (int i=0; i<s.length(); i++) {
	char c = s.charAt(i);
	/* // Version ohne chars und indexOf
	if ((c>="A"&&c<="Z")||(c>="a"&&c<="z")||(c=="."||c==":"))
	  f += c;
	*/
	if (chars.indexOf(c)>=0) f += c;
  }
  return f.toLowerCase();
} // filter()
}