import mathe.FormattedOut;
/**
 * AlgDs WS99 Aufgabe 23
 * int[] sortieren.
 *
 * @author Christian Semrau, 28.11.1999, 25.12.1999
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
class ChS_Aufg23 {
  static int[] werte;

// Vergleicht zwei int-Werte und erhoeht den Vergleichszaehler.
public static int compare(int X,int Y) {
  werte[0]++;
  return X-Y;
}

// Liefert einen String, der den Feldinhalt darstellt.
public static String feldOut(int[] feld) {
  if (feld.length==0) {return "{}"; };

  String s = "{"+feld[0];
  for(int i=1; i<feld.length; i++) {
	s += ","+feld[i];
	if (i%20==0) s += "\n";
  }
  return s+"}";
}

/**
 * Liefert ein initialisiertes Feld.
 * @return int[]
 * @param m
 * 0 = aufsteigend (0..anzahl-1),
 * 1 = absteigend (anzahl-1..0),
 * 2 = zufaellig (Werte in 0..anzahl-1)
 */
public static int[] initfeld(int anzahl, int m) {
  int[] feld = new int[anzahl];
  System.out.print(anzahl);

  switch (m){
	case 0:
	  System.out.println(" aufsteigend");
	  for(int i=0; i<anzahl; i++) feld[i]=i;
	  break;
	case 1:
	  System.out.println(" absteigend");
	  for(int i=0; i<anzahl; i++) feld[i]=anzahl-1-i;
	  break;
	case 2:
	  System.out.println(" zufaellig");
	  for(int i=0; i<anzahl; i++)
	    feld[i]=(int)(anzahl*Math.random());
  }
  return feld;
}

/**
 * Sortieren von int-Feldern nach
 * Insertion, Selection, Bubble, Quick, Merge-Sort
 *
 */
public static void main(java.lang.String[] args) {
  int[] groessen = {10,100,1000};
  int[] testfeld;
  int[][] wertefeld = new int[5][];

  for (int gr=0; gr<3; gr++)
  for (int m=0; m<3; m++) {

  int[] originalfeld = initfeld(groessen[gr],m);
  //System.out.println(feldOut(originalfeld));

  testfeld = (int[])originalfeld.clone();
  sortInsertion(testfeld);  wertefeld[0] = werte;

  testfeld = (int[])originalfeld.clone();
  sortSelection(testfeld);  wertefeld[1] = werte;

  testfeld = (int[])originalfeld.clone();
  sortBubble(testfeld);  wertefeld[2] = werte;

  testfeld = (int[])originalfeld.clone();
  sortQuick(testfeld);  wertefeld[3] = werte;

  testfeld = (int[])originalfeld.clone();
  sortMerge(testfeld);  wertefeld[4] = werte;

  String[] namen = new String[]{"Insertion", "Selection",
	"Bubble   ", "Quick    ", "Merge    "};

  for (int i=0; i<5; i++)
	System.out.println(namen[i]+": "
	+"Vergleiche:"+FormattedOut.right(wertefeld[i][0],6)
	+", Kopien:"  +FormattedOut.right(wertefeld[i][1],6));

  }
}

public static void sortBubble(int[] feld) {
  werte = new int[2];
  // werte[0] = Vergleiche, werte[1] = Kopien

//  System.out.println(feldOut(feld));
  boolean swapped; int max = feld.length-1;
  do {
	swapped = false;
	for (int i = 0; i < max; i++) {
	  werte[0]++;
	  if (feld[i] > feld[i + 1]) {
		//Elemente vertauschen
		swap (feld, i,i +1);
	    werte[1]+=3;
		swapped = true;
	  }
	}
	max--;
//	System.out.println(feldOut(feld));
  } while (swapped);  //solange Vertauschung auftritt
}

public static void sortInsertion(int[] feld) {
  werte = new int[2];
  // werte[0] = Vergleiche, werte[1] = Kopien

//  System.out.println(feldOut(feld));
  for (int i = 1; i < feld.length; i++){
	int marker = i;
	int temp = feld[i]; werte[1]++;
	//fuer alle Elemente links vom Marker-Feld
	while (marker > 0 && compare(feld[marker - 1],temp)>0) {
	  // verschiebe alle groesseren Element nach hinten
	  feld[marker] = feld[marker - 1];
	  werte[1]++;
	  marker--;
	}
	if (marker!=i) {
	  //setze temp auf das freie Feld
	  feld[marker] = temp;
	  werte[1]++;
	}
//	System.out.println(feldOut(feld)+" marker="+marker);
  }
}

public static void sortMerge (int[] array) {
  werte = new int[2];
  // werte[0] = Vergleiche, werte[1] = Kopien

  sortMerge2(array, 0, array.length - 1);
//  System.out.println(feldOut(array));
}

static void sortMerge2(int[] array, int l, int r) {
  int i, j, k;
  int[] b = new int[array.length];
  if (r > l) {
	// zu sortierendes Feld teilen
	int mid = (r + l) / 2;
	// Teilfelder sortieren
	sortMerge2(array, l, mid);
	sortMerge2(array, mid + 1, r);
//	System.out.println(feldOut(array));
	// Ergebnisse mischen ueber Hilfsfeld b
	for (i = mid + 1; i > l; i--) {
	  b[i - 1] = array[i - 1];
	  werte[1]++;
	}
	for (j = mid; j < r; j++) {
	  b[r + mid - j] = array[j + 1];
	  werte[1]++;
	}
	for (k = l; k <= r; k++) {
	  if (b[i] < b[j])
		array[k] = b[i++];
	  else
		array[k] = b[j--];
	  werte[1]++;
	  werte[0]++;
	}
  }
}

public static void sortQuick (int[] array) {
  werte = new int[2];
  // werte[0] = Vergleiche, werte[1] = Kopien
  sortQuick2(array, 0, array.length - 1);
}
static void sortQuick2(int[] array, int l, int r) {
  int lo = l,hi = r;
  if (hi > lo) {
	// Pivotelement bestimmen
	int mid = array[(lo + hi) / 2];
//	System.out.println(feldOut(array)+" "+mid);
	werte[1]++;
	while (lo <= hi) {
	  while ((lo < r) && (compare(array[lo],mid)<0)) lo++; 
	  while (( hi > l ) && (compare(array[hi],mid)>0)) hi--;
	  if (lo <= hi) {
		if (lo<hi) {
	      swap(array, lo, hi);
	      werte[1]+=3;
		};
		lo++; hi--;
	  }
	}
//	System.out.println(feldOut(array));
	// linke Partition sortieren
	if (l < hi) sortQuick2(array, l, hi);
	// rechte Partition sortieren
	if (lo < r) sortQuick2(array, lo, r);
  }
}
public static void sortSelection(int[] feld) {
  werte = new int[2];
  // werte[0] = Vergleiche, werte[1] = Kopien

//  System.out.println(feldOut(feld));
  int marker = feld.length - 1;
  while (marker >= 0) {
	//bestimme groesstes Element
	int max =0;
	for (int i = 1; i <= marker; i++) {
	  if (feld[i] > feld[max])
		max =i;
	  werte[0]++;
	}
	if (marker!=max) {
	  //tausche array[marker]mit diesem Element
	  swap (feld, marker, max);
	  werte[1]+=3;
	}
	marker--;
//	System.out.println(feldOut(feld));
  };
}
public static void swap (int[] array, int idx1, int idx2) {
  int tmp = array[idx1];
  array[idx1] = array[idx2];
  array[idx2] = tmp;
}
} // class ChS_Aufg23