import mathe.FormattedOut;
/**
 * AlgDs, WS99, Aufgabe 20.
 * Primzahlsieb des Eratosthenes.
 *
 * @author Christian Semrau, 15.11.1999, 24.12.1999
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
class ChS_Aufg20 {

  static boolean[] isprim;
  // true, wenn Primzahl, false wenn nicht
  // Index entspricht dargestellter Zahl (0 wird ignoriert)

  static int sets=0;
  // Anzahl der Streichungen
  // Die Zuweisungen an sets dienen nur dem Vergleich der Varianten
  // und sind nicht Teil des eigentlichen Algorithmus!

  static int max;
  static int maxsqrt;


public static void main(java.lang.String[] args) {
  System.out.println("AlgDs WS99 Aufgabe 20, Christian Semrau 15.11.1999");

  max = 1000;  // Groesse des Feldes
  maxsqrt = (int)Math.sqrt(max);

  isprim = new boolean[max+1];
  isprim[1]=false; // 1 ist keine Primzahl
  for (int i=2; i<=max; isprim[i++]=true);  // 2 bis max auf true setzen

  switch(3) { // Angabe, welche Version ausgefuehrt werden soll
  case 0: primsiebBasis(); break;
  case 1: primsiebBasis2(); break;
  case 2: primsiebEAVPre(); break;
  case 3: primsiebEAV(); break;
  case 4: primsiebEAV2(); break;
  case 5: primsiebIvo();
  } // switch

/*
 * Wer behauptet "Ich habe eine kuerzere Eine-Anweisung-Version",
 * der soll den Vergleich nochmal machen, wenn alle Bezeichner auf
 * einen Buchstaben gekuerzt und die Leerzeichen entfernt sind:
 * m=max; s=maxsqrt; p=isprim;
 * for(j=i=2;i<=s;p[(j*i>m||!p[i])&&(j=++i)>s?0:j++*i]=false);  // meine
 * for(j=i=2;i<=s;p[j*i>m?(j=2)*i++:j++*i]=false);  // meine andere
 * for(i=j=2;i<=m/2;p[(i*j>m||!p[i])?j=2*i++:j++*i]=false);  // Ivos
 */

  primsiebOut();
  System.out.println(sets+" Streichungen");
} // main()

// Basisversion
public static void primsiebBasis() {
  for (int i=2; i<=maxsqrt; i++) {
	if (isprim[i])   // nur Vielfache von Primzahlen streichen
	for (int j=i*i; j<=max; j+=i) {
	// die Vielfachen von i, beginnend beim Quadrat..
	  isprim[j]=false;     // sind keine Primzahlen
	  sets++;
	}
  }
}

// verkuerzte Basisversion
public static void primsiebBasis2() {
  for (int i=2; i<=maxsqrt; i++)
	if (isprim[i])
	  for (int j=i; j*i<=max; isprim[j++*i]=false) sets++;
}

/* ---------------------------------------------------------------
 * -------------- Meine "Eine-Anweisung-Version" -----------------
 * ---------------------------------------------------------------
 *
 * Mancher fragt sich vielleicht, warum ich versuche, Ivos EAV zu toppen.
 * Zum einen ist da die Herausforderung, es kuerzer zu schaffen, und
 * zum anderen ist seine Version nicht optimal (mehr Streichungen als noetig):
 *
 * Siebgroesse:  100 1000 10000 100000
 * Primzahlen:    25  168  1229   9592
 * Anzahl der Streichungen:
 * Basisversion: 104 1411 16981 193078
 * meine E-A-V:  110 1431 17056 193329
 * Ivos E-A-V:   195 2457 28070 306807
 *
 * Wie gut, dass es die Short-Circuit-Auswertung gibt:
 * Ich gehe davon aus, dass die Bedingungen immer von links nach rechts
 * ausgewertet werden (Dieses Verhalten schliesse ich jedenfalls aus
 * Go To Java 2 Kapitel 5.4), damit wird der Teil nach dem &&
 * genau dann ausgewertet, wenn es noetig ist.
 */
 //---------------------------------------------------------
public static void primsiebEAV() {
  for (int j=2,i=2; i<=maxsqrt; isprim[
	(j*i>max || !isprim[i]) && (j=++i)>maxsqrt
	? 0 : j++*i ]=false) sets++;
}//---------------------------------------------------------

/* meine andere Version
 * ist zwar kuerzer, verzichtet aber auch auf fast alles, was
 * den Algorithmus beschleunigt: kein Ueberspringen von bereits
 * gestrichenen Werten, die Streichung der Vielfachen beginnt
 * schon beim Doppelten von i
 */
public static void primsiebEAV2() {
  for(int j=2,i=2; i<=maxsqrt; isprim[ j*i>max ? (j=2)*i++ : j++*i]=false) sets++;
}

/* fast fertige "Eine-Anweisung-Version"
 */
public static void primsiebEAVPre() {
  for (int j=2, i=2; i<=maxsqrt;
	isprim[ (j*i>max || !isprim[i])
	  ? (j=++i)>maxsqrt ? 0 : (j++*i)
	  : (j++*i)
	]=false) sets++;
}

/* Ivo Roesslings "Eine-Anweisung-Version", an mein Programm angepasst
 * Fehler: (i*j>max-1) muss (i*j>max) sein (hier korrigiert):
 * wenn max = sqr(einePrimzahl) dann wird die letzte nicht gestrichen
 */
public static void primsiebIvo() {
  for (int i=2,j=2; i<=max/2; isprim[
	((i*j>max) || !isprim[i])
	? ((j=2)*(i++)) : ((j++)*i) ] = false) sets++;
}

// Ausgabe der Primzahlen
public static void primsiebOut() {
  int anzahl=0;
  for (int i=1; i<=max; i++)
	if (isprim[i]) {
	  System.out.print(FormattedOut.right(" "+i,5));
	  if ((++anzahl)%10==0)
		System.out.println();
	}
  if (anzahl%10!=0) System.out.println();
  // right() und das (anzahl%10==0) dienen nur der Verschoenerung der
  // Ausgabe (zehn Zahlen in einer Zeile, rechtsbuendig uebereinander)

  System.out.println(anzahl+" Primzahlen <= "+max);
  // Ausgabe, wieviele Primzahlen gefunden wurden
}
} // class ChS_Aufg20