import algds.IOUtils;
/**
 * AlgDs, WS99, Aufgabe 18.
 * Erzeugt ein Feld mit Zufallszahlen.
 *
 * Groesse des Feldes und Maximum der Zufallszahlen wird eingegeben.
 * Es wird das Minimum mit seiner Position und der Durchschnitt ausgegeben.
 *
 * @author Christian Semrau, 13.11.1999, 24.12.1999
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
class ChS_Aufg18 {

public static void main(String[] args) {
  int n, maxrand;

  System.out.println("AlgDs WS99 Aufgabe 18, Christian Semrau.");

  do {
	System.out.print("Feldgroesse:"); n=IOUtils.readInt();
  } while (n<=0);  // mindestens ein Element

  do {
	System.out.print("Maximum:"); maxrand=IOUtils.readInt();
  } while (maxrand<1);  // Maximum mindestens 1

  maxrand++;  // Random() braucht eine um eins hoehere Zahl

  int[] feld = new int[n];  // Das Feld anlegen

  for (int i=0; i<n; i++)
	feld[i] = (int) (maxrand*Math.random());
	// die Werte von feld[i] liegen in 0..maxrand-1

  // Feldausgabe
  /*
  for (int i=0; i<n; i++) System.out.print(feld[i]+", ");
  System.out.println();
  */

  // Bestimmung des Minimums
  int min=feld[0], minpos=0;
  for (int i=1; i<n; i++) // laeuft von 1 bis n-1
	if (feld[i]<min) {min=feld[i]; minpos=i;}

  System.out.println("Minimum "+min+" an Index "+minpos);

  long summe=0;
  // obwohl alle Feldeintraege int sind, kann ihre Summe zu
  // gross fuer ein int werden
  // (z.B. n=10000, maxrand=10000000, Ausprobieren!!)

  for (int i=0; i<n; i++) summe+=feld[i];
  // Aufsummieren

  System.out.println("Summe: "+summe+", Durchschnitt: "+((float)summe/n));
  // erst wird summe in float umgewandelt, und dann eine float-Division
  // durchgefuehrt
} // main()
} // class ChS_Aufg18