import algds.IOUtils;
/**
 * AlgDs WS99 Aufgabe 16.
 *
 * Zwei applikative Algorithmen:
 *<code>
 *  a) f(x) = (x>100) ? x-10 : f(f(x+11))
 *  b) g(x) = (x==1) ? 1 : g(h(x))
 *     h(x) = (x%2==0) ? x/2 : 3*x+1
 *</code>
 *
 * @author Christian Semrau, 13.11.1999, 24.12.1999
 * <a href="mailto:Christian.Semrau@student.uni-magdeburg.de">
 * Christian.Semrau@student.uni-magdeburg.de</a>
 */
public class ChS_Aufg16 {

/**
 * Liefert 91 fuer x<=100, x-10 fuer x>100
 */
public static int f(int x) {
  return( (x>100) ? x-10 : f(f(x+11)) );
}

/**
 * Liefert fuer x>0 immer 1, fuer x<=0 nicht terminierend.
 */
public static int g(int x) {
  return( (x==1) ? 1 : g(h(x)) );
}

/**
 * Hilfsfunktion von g
 */
public static int h(int x) {
  return( (x%2==0) ? x/2 : 3*x+1 );
}

/**
 * Erlaubt eine einmalige Auswahl des Algorithmus, um diesen dann auszufueren.
 */
public static void main(String[] args) {
  int alg;  // Welcher Algorithmus

  System.out.println("AlgDs WS99 Aufgabe 16, Christian Semrau, 13.11.1999");
  System.out.println(
	"1: a) f(x) = (x>100) ? x-10 : f(f(x+11))\n"+
	"2: b) g(x) = (x==1) ? 1 : g(h(x))\n"+
	"      h(x) = (x%2==0) ? x/2 : 3*x+1");
  do {
	System.out.print("Welcher Algorithmus [1,2]?");
	alg = IOUtils.readInt();
  } while (alg<1||alg>2);

  int x,y;
  System.out.print("x:"); x = IOUtils.readInt();

  switch (alg) {
	case 1: y=f(x); System.out.println("f("+x+")="+y); break;
	case 2: y=g(x); System.out.println("g("+x+")="+y); break;
  }
}
} // class ChS_Aufg16